/***************************************************************************
 *   Copyright (C) 2008-2009 by Manuel Schrape                             *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "cQMK_Server.h"
#include "ToolBox.h"

cQMK_Server::cQMK_Server()
{
}

void cQMK_Server::Connect(QString IP, int Port, QString User, QString Pass)
{
    Username = User;
    Password = Pass;

    TcpSocket = new(QTcpSocket);
    TcpSocket->connectToHost (IP, Port);

    connect(TcpSocket, SIGNAL(connected()), this, SLOT(slot_Connected()) );
    connect(TcpSocket, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(slot_Error(QAbstractSocket::SocketError)));
}

void cQMK_Server::Disconnect()
{
    TcpSocket->disconnectFromHost();
    disconnect(TcpSocket, SIGNAL(connected()), 0, 0);
    disconnect(TcpSocket, SIGNAL(readyRead()), 0, 0);
    disconnect(TcpSocket, SIGNAL(disconnected()), 0, 0);
}

void cQMK_Server::SendData(int CMD, QString Data)
{
    QString SendString = QString(QString("%1").arg(CMD) + ":" + Data + ":");

    int CRC = qChecksum(SendString.toLatin1().data(), SendString.length());
    QString sCRC = QString("%1").arg(CRC);

    SendString = SendString + sCRC + "\n";

    QByteArray SendText = SendString.toAscii();

    TcpSocket->write(SendText);
}

void cQMK_Server::NewPosition(sNaviString Pos)
{
    if (1==1)
    {
        SendData(100, QString(Pos.Longitude + ":" + Pos.Latitude + ":" + Pos.Altitude));
    }
}

void cQMK_Server::send_RawData(QString Data)
{
    Data = Data + "\n";

    QByteArray SendText = Data.toAscii();

    TcpSocket->write(SendText);
}

void cQMK_Server::slot_Connected()
{
    connect(TcpSocket, SIGNAL(readyRead()), SLOT(slot_ReadLine()));
    connect(TcpSocket, SIGNAL(disconnected()),TcpSocket, SLOT(deleteLater()));
    connect(TcpSocket, SIGNAL(disconnected()),this, SLOT(slot_Disconnect()));

    emit sig_Connected();
}

void cQMK_Server::slot_Disconnect()
{
    disconnect(TcpSocket, SIGNAL(disconnected()), 0, 0);
    emit sig_Disconnected(1);
}

void cQMK_Server::slot_Error(QAbstractSocket::SocketError Error)
{
    switch (Error)
    {
        case QAbstractSocket::ConnectionRefusedError:
            emit sig_Disconnected(2);
        break;
        case QAbstractSocket::RemoteHostClosedError:
            emit sig_Disconnected(1);
        break;
        default:
            emit sig_Disconnected(0);
        break;
    }

    disconnect(TcpSocket, SIGNAL(disconnected()), 0, 0);
    emit sig_Disconnected(2);
}

void cQMK_Server::slot_ReadLine()
{
    QString Input = QString(TcpSocket->readLine(TcpSocket->bytesAvailable())).remove(QChar('\n'));

    QStringList Data = Input.split(":");

    if (Data.count() > 1)
    {
        int CMD = Data[0].toInt();

        switch(CMD)
        {
            case 1 :
            {
                SendData(1, QString(QA_NAME + " " + QA_VERSION + " [" + QA_OS + "]:" + Username + ":" + Password + ":"));
            }
            break;
            case 2 :
            {
//                qDebug("Login OK");
            }
            break;
            case 3 :
            {
                emit sig_Disconnected(3);
            }
            break;
        }
    }
}



